/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter;

import com.aptana.editor.css.formatter.nodes.FormatterCSSCommentNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterNodeRewriter;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSFormatterNodeRewriter
extends FormatterNodeRewriter {
    private static final Pattern COMMENT_LINE_PATTERN = Pattern.compile("(\\S.*)");
    private static final String MULTI_LINE_COMMENT_PREFIX = "/*";

    public CSSFormatterNodeRewriter(IParseRootNode parseResult, FormatterDocument document) {
        this.insertComments(document, parseResult.getCommentNodes());
    }

    private void insertComments(FormatterDocument document, IParseNode[] comments) {
        IParseNode[] iParseNodeArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            int endingOffset;
            IParseNode commentNode = iParseNodeArray[n2];
            int startingOffset = commentNode.getStartingOffset();
            String commentText = document.get(startingOffset, endingOffset = commentNode.getEndingOffset() + 1);
            if (commentText.startsWith(MULTI_LINE_COMMENT_PREFIX)) {
                Matcher matcher = COMMENT_LINE_PATTERN.matcher(commentText);
                boolean isFirstLine = true;
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    this.addComment(startingOffset + start, startingOffset + end, new CSSCommentInfo(true, isFirstLine));
                    isFirstLine = false;
                }
            } else {
                this.addComment(startingOffset, endingOffset, new CSSCommentInfo(false, false));
            }
            ++n2;
        }
    }

    protected IFormatterNode createCommentNode(IFormatterDocument document, int startOffset, int endOffset, Object object) {
        CSSCommentInfo info = (CSSCommentInfo)object;
        return new FormatterCSSCommentNode(document, startOffset, endOffset, info.isMultiLine, info.isFirstLine);
    }

    private class CSSCommentInfo {
        final boolean isMultiLine;
        final boolean isFirstLine;

        CSSCommentInfo(boolean isMultiLine, boolean isFirstLine) {
            this.isMultiLine = isMultiLine;
            this.isFirstLine = isFirstLine;
        }
    }
}

